import { __ } from "@wordpress/i18n";
import {
	RangeControl,
	SelectControl,
	ColorPicker,
	PanelRow,
} from "@wordpress/components";

const typographyFirstField = ({
	firstFieldfontWeight,
	sliderMobileSize,
	sliderTabletSize,
	sliderDesktopSize,
	textColorFirstField,
	isMobile,
	isTablet,
	isDesktop,
	setAttributes,
}) => {
	return (
		<>
			<SelectControl
				label="Font Weight"
				value={firstFieldfontWeight}
				options={[
					{ label: __("Normal", "text-domain"), value: "normal" },
					{ label: __("Bold", "text-domain"), value: "bold" },
					{ label: __("Bolder", "text-domain"), value: "bolder" },
					{ label: __("Lighter", "text-domain"), value: "lighter" },
					{ label: __("Italic", "text-domain"), value: "italic" },
				]}
				onChange={(value) => setAttributes({ firstFieldfontWeight: value })}
			/>
			<RangeControl
				__nextHasNoMarginBottom
				__next40pxDefaultSize
				label={ isDesktop ? "Select Desktop Font Size" : isTablet ? "Select Tablet Font Size" : "Select Mobile Font Size"}
				value={
					isDesktop
						? sliderDesktopSize
						: isTablet
						? sliderTabletSize
						: sliderMobileSize
				}
				onChange={(value) =>
					isDesktop
						? setAttributes({ sliderDesktopSize: value })
						: isTablet
						? setAttributes({ sliderTabletSize: value })
						: setAttributes({ sliderMobileSize: value })
				}
				min={10}
				max={100}
			/>
			<PanelRow className="panel-column">
				<label className="fontLabel">
					{__("SELECT FONT COLOR", "super-simple-image-slider")}
				</label>
				<ColorPicker
					color={textColorFirstField}
					onChange={(newColor) =>
						setAttributes({ textColorFirstField: newColor })
					}
					enableAlpha
					defaultValue="#000"
				/>
			</PanelRow>
		</>
	);
};

export default typographyFirstField;
